window.onload = function() {

var APP_WIDTH = 350;
var APP_HEIGHT = 440;
var PADDLE_WIDTH = 50;
var PADDLE_HEIGHT = 10;
var PADDLE_OFFSET = 30;
var BALL_RADIUS = 6;

var NUM_ROWS = 10;
var BRICK_TOP_OFFSET = 10;
var BRICK_SPACING = 2;
var NUM_BRICKS_PER_ROW = 10;
var BRICK_HEIGHT = 10;
var BRICK_WIDTH = (APP_WIDTH - (NUM_BRICKS_PER_ROW + 1) * BRICK_SPACING) / NUM_BRICKS_PER_ROW;

var paddle, ball;
var vx; 
var vy = 10;
var gameOver = false;
var NUM_TURNS = 3;
var turnsLeft = NUM_TURNS;
var score = 0;
var scoreText;
var lives;
var breakout = new Audio('breakout.mp3');
var pop = new Audio('pop.mp3');
var bat = new Audio('bat.mp3');
var woohoo = new Audio('woohoo.mp3');
var haha = new Audio('haha.mp3');
var doh = new Audio('doh.mp3');
var crunch = new Audio('crunch.mp3');
var wahwahwah = new Audio('WahWahWah.mp3');
var cheer = new Audio('cheer.mp3');
var ballhitwall = new Audio('ballhitwall.mp3');
var level = 1;
var levelText;
var canvas = document.getElementById("canvas");

var name = localStorage.getItem("getName") || "";

var highScore = localStorage.getItem("myHighScore") || 0;
var highscore = document.getElementById("highscore");
var levelBrickCount = 0;

const LEVELS = [
  // Level 1 â€“ full grid
  Array(NUM_ROWS).fill().map(() => Array(NUM_BRICKS_PER_ROW).fill(1)),

  // Level 2 â€“ Pattern (dove shape) 28Ã—3+8Ã—2
  [
    [1,1,1,0,0,0,0,1,1,1],
    [0,1,1,1,0,0,1,1,1,0],
    [0,0,1,1,0,0,1,1,0,0],
    [0,0,0,1,1,1,1,0,0,0],
    [0,0,0,0,1,1,0,0,0,0],
    [0,0,0,0,1,1,0,0,0,0],
    [0,0,0,1,0,0,1,0,0,0],
    [0,0,0,1,0,0,1,0,0,0],
    [0,0,1,0,1,1,0,1,0,0],
    [0,0,1,0,1,1,0,1,0,0]
  ],

  // Level 3 â€“ Pattern (fish shape) 4Ã—3+44Ã—2
  [
    [0,0,0,1,1,0,0,0,0,0],
    [0,0,0,1,1,0,0,0,0,0],
    [0,0,1,1,1,1,0,0,0,1],
    [0,1,1,1,1,1,1,0,1,0],
    [1,1,1,1,1,1,1,1,0,0],
    [1,1,1,1,1,1,1,1,0,0],
    [0,1,1,1,1,1,1,0,1,0],
    [0,0,1,1,1,1,0,0,0,1],
    [0,0,0,1,1,0,0,0,0,0],
    [0,0,0,1,1,0,0,0,0,0]
  ],

  // Level 4 â€“ Pattern (cup shape) 50Ã—2
  [
    [1,1,1,1,1,1,1,1,1,1],
    [0,1,1,1,1,1,1,1,1,0],
    [0,0,1,1,1,1,1,1,0,0],
    [0,0,0,1,1,1,1,0,0,0],
    [0,0,0,0,1,1,0,0,0,0],
    [0,0,0,0,1,1,0,0,0,0],
    [0,0,0,0,1,1,0,0,0,0],
    [0,0,0,1,1,1,1,0,0,0],
    [0,0,1,1,1,1,1,1,0,0],
    [0,0,1,1,1,1,1,1,0,0]
  ],

  // Level 5 â€“ Pattern (wafer shape) 36Ã—2+28Ã—1
  [
    [0,1,1,0,1,1,0,1,1,0],
    [0,1,1,0,1,1,0,1,1,0],
    [1,1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1,1],
    [0,1,1,0,1,1,0,1,1,0],
    [0,1,1,0,1,1,0,1,1,0]
  ]
];

    const LEVEL_SCORES = [
        {
            threshold: 100,
            scoreA: 1,
            scoreB: 1
        },
        {
            threshold: 28,
            scoreA: 3,
            scoreB: 2
        },
        {
            threshold: 4,
            scoreA: 3,
            scoreB: 2
        },
        {
            threshold: 50,
            scoreA: 2,
            scoreB: 2
        },
        {
            threshold: 16,
            scoreA: 2,
            scoreB: 1
        }
    ];

    if(highScore === 0){
    highscore.textContent = `High score: 0`;
    }

    else{
    highscore.textContent = `${name} High score: ${highScore}0`;
}

function playMusic(){
    breakout.loop = true;
    breakout.play();
    breakout.volume = 0.6;

}

document.addEventListener("keydown", (e) => {
  if (e.key === "m") {
    breakout.paused ? breakout.play() : breakout.pause();
  }
});

document.getElementById("playPauseBtn").addEventListener("click", () => {
    breakout.paused ? breakout.play() : breakout.pause();
});

function setupBall(){
	ball = new WebImage("ball.png");
	ball.setPosition(getWidth()/2, getHeight()/2);
 	add(ball);
}

function setupPaddle() {
    paddle = new WebImage("paddle.png");
    paddle.setSize(PADDLE_WIDTH, PADDLE_HEIGHT);
    paddle.setPosition(
        APP_WIDTH / 2 - PADDLE_WIDTH / 2,
        APP_HEIGHT - PADDLE_HEIGHT - PADDLE_OFFSET
    );
    add(paddle);
}

var brickImages = [
  'brick0.png',
  'brick1.png',
  'brick2.png',
  'brick3.png',
  'brick4.png',
  'brick5.png',
  'brick6.png',
  'brick7.png',
  'brick8.png',
  'brick9.png'
  // ... add more image URLs
];

function drawBrick(x, y){
    var index = Randomizer.nextInt(0, brickImages.length - 1);
    var brick = new WebImage(brickImages[index]);

    brick.setSize(BRICK_WIDTH, BRICK_HEIGHT);
    brick.setPosition(x, y);
    add(brick);
}

function drawBricks() {
    let layout = LEVELS[(level - 1) % LEVELS.length];
    bricksLeft = 0;

    for (let row = 0; row < layout.length; row++) {
        for (let col = 0; col < layout[row].length; col++) {
            if (layout[row][col] === 1) {
                let x = BRICK_SPACING + col * (BRICK_WIDTH + BRICK_SPACING);
                let y = BRICK_TOP_OFFSET + row * (BRICK_HEIGHT + BRICK_SPACING);
                drawBrick(x, y);
                bricksLeft++;
            }
        }
    }
    levelBrickCount = bricksLeft;
}

function getBrickScore() {
    var pointsInfo = LEVEL_SCORES[(level - 1) % LEVEL_SCORES.length];
    return bricksLeft >= levelBrickCount - pointsInfo.threshold ? pointsInfo.scoreA : pointsInfo.scoreB;
}

function setSpeeds(){
	vx = Randomizer.nextInt(2, 7);
	if(Randomizer.nextBoolean()){
		vx = -vx;
	}
}

function setup(){
	drawBricks();
	setupPaddle();
	setupBall();
	setSpeeds();
    setupScore();
    setupLives();
    setupLevel();
}

function levelup(){
    levelStarted = false;
	drawBricks();
    setupBall();
	setSpeeds();
    vy = 10;
    levelText.setText(`Level: ${level}`);
    if(level %5 === 0){
        turnsLeft++;
    if(turnsLeft > 6){
        turnsLeft = 6;
}
        lives.setText(`Lives: ${turnsLeft}`);
    }
    if(level %5 %2 === 0){PADDLE_WIDTH = 42;}
    else{PADDLE_WIDTH = 50;}
    if(level %5 === 0){PADDLE_WIDTH = 50;}
    remove(paddle);
    setupPaddle();
}


function checkWalls(){
	if(ball.getX() < 0 || ball.getX() + ball.getHeight() > getWidth()){
		vx = -vx;
        ballhitwall.play();
	}
	if(ball.getY() < 0){
		vy = -vy;
        ballhitwall.play();
	}

	if(ball.getY() + ball.getHeight() > getHeight()){
		gameOver = true;
	}
}

function getCollidingObject(){
	var left = ball.getX() - 0.5;
	var right = ball.getX() + ball.getHeight() + 0.5;
	
	var top = ball.getY() - 0.5;
	var bottom = ball.getY() + ball.getHeight() + 0.5;
	
	var topLeft = getElementAt(left, top);
	if(topLeft) return topLeft;
	
	var topRight = getElementAt(right, top);
	if(topRight) return topRight;
	
	var bottomLeft = getElementAt(left, bottom);
	if(bottomLeft) return bottomLeft;
	
	var bottomRight = getElementAt(right, bottom);
	if(bottomRight) return bottomRight;
}

function checkObjects(){
	var elem = getCollidingObject();
    console.log(elem);
	if(elem != null && ![ball, scoreText, lives, levelText].includes(elem)){
		if(elem != paddle){
			remove(elem);
            pop.play();
			vy = -vy;
			bricksLeft--;
            let points = getBrickScore();
            score += points;
            scoreText.setText(`Score: ${score}0`);

  if(score > highScore){
    highScore = score;
    name = "Your";
    highscore.textContent = `${name} High score: ${highScore}0`;
    localStorage.setItem("myHighScore", highScore);
  };
		}else{
            bat.play();
			vy = -Math.abs(vy);
		}
	}
}

function drawGameOver(){
	var text = new Text("Game over", "25pt Arial");
	text.setPosition(getWidth()/2 - text.getWidth()/2, getHeight()/2);
    text.setColor(Color.red);
	add(text);
    breakout.pause();
    remove(ball);
    if(score < 41) {
    setTimeout(function(){haha.play();
}, 1000);
    setTimeout(function(){wahwahwah.play();
}, 2500);
    document.exitPointerLock();
    if(score === highScore){
        highScoreName();
    }
}
    else if(score < 100){
    setTimeout(function(){doh.play();
}, 1000);
    setTimeout(function(){wahwahwah.play();
}, 2000);
    document.exitPointerLock();
    if(score === highScore){
        highScoreName();
    }
}
    else {drawGameWon();
}
}

function setupScore(){
	var text = new Text("Score: 0", "12pt Arial");
	text.setPosition(3, getHeight()-3);
    scoreText = text;
    text.setColor(Color.white);
	add(text);
}

function setupLives(){
	var text = new Text("Lives: 3", "12pt Arial");
	text.setPosition(getWidth()-3-text.getWidth(), getHeight()-3);
    lives = text;
    text.setColor(Color.white);
	add(text);
}

function setupLevel(){
	var text = new Text("Level: 1", "12pt Arial");
	text.setPosition(getWidth()/2-text.getWidth()/2, getHeight()-3);
    levelText = text;
    text.setColor(Color.white);
	add(text);
}

function drawGameWon(){
	var text = new Text(`You past level 1 to level ${level}!`, "20pt Arial");
	text.setPosition(getWidth()/2 - text.getWidth()/2, getHeight()/2+30);
    text.setColor(Color.green);
	add(text);
    setTimeout(function(){cheer.play();
}, 1000);
    document.exitPointerLock();
    if(score === highScore){
	var text = new Text(`You got the High Score!`, "20pt Arial");
	text.setPosition(getWidth()/2 - text.getWidth()/2, getHeight()/2+60);
    text.setColor(Color.green);
	add(text);
    setTimeout(function(){woohoo.play();
    }, 1000);
        highScoreName();
    }
}

function checkWin(){
	if(bricksLeft == 0){
        remove(ball);
        level++;
		stopTimer(draw);
        start();
	}
}
var fromLose = false;
function checkLose(){
	if(gameOver){
		turnsLeft--;
        lives.setText(`Lives: ${turnsLeft}`);
		remove(ball);
        crunch.play();
		if(turnsLeft == 0){
			stopTimer(draw);				
			drawGameOver();
		}
		else{
			stopTimer(draw);
            levelStarted = false;
            fromLose = true;
            setupBall();
			gameOver = false;
		}
	}	
}

function highScoreName(){
const container = document.createElement('div');
container.style.margin = '10px auto';
container.style.textAlign = 'center';

const input = document.createElement('input');
input.type = 'text';
input.id = 'playerName';
input.placeholder = 'Enter short name';
input.style.padding = '5px';
input.style.fontSize = '14px';
input.style.marginBottom = '5px';

container.appendChild(input);

document.body.appendChild(container);

input.addEventListener('keydown', function(event) {
  if (event.key === 'Enter') {
    event.preventDefault(); 
    const name = input.value.trim();
    if (name) {
      localStorage.setItem('getName', name);
      highscore.textContent = `${name} High score: ${highScore}0`;
      container.remove();
    } else {
      alert('Please enter a valid name.');
    }
  }
});
}

function draw(){
	checkWalls();
	checkObjects();
	ball.move(vx, vy);
	checkWin();
	checkLose();
}

canvas.requestPointerLock = canvas.requestPointerLock ||
                            canvas.mozRequestPointerLock;

document.exitPointerLock = document.exitPointerLock ||
                           document.mozExitPointerLock;

canvas.onclick = function() {
    canvas.requestPointerLock();
};

// pointer lock event listeners
var levelStarted = false;
function onMouseClicked(e) {
    if (!levelStarted) {
	    setTimer(draw, 40);
        levelStarted = true;
        if (fromLose) {
	        setSpeeds();
            fromLose = false;
        }
    }
}

// Hook pointer lock state change events for different browsers
document.addEventListener('pointerlockchange', lockChangeAlert, false);
document.addEventListener('mozpointerlockchange', lockChangeAlert, false);
canvas.addEventListener("mousedown", onMouseClicked, false);
canvas.addEventListener("touchstart", handleTouch, false);
canvas.addEventListener("touchmove", handleTouch, false);
document.addEventListener("contextmenu", function(event) {
    event.preventDefault();
});
function handleTouch(e) {
    e.preventDefault(); // Prevent scrolling
    if(e.type == "touchstart"){
        onMouseClicked();
    }
    const rect = canvas.getBoundingClientRect();
    const touch = e.touches[0];
    const touchX = touch.clientX - rect.left + PADDLE_WIDTH / 3;
    var x = touchX - PADDLE_WIDTH;

    // Clamp paddle position
    if (x < 0) paddle.x = 0;
    else if (x + PADDLE_WIDTH > APP_WIDTH) paddle.x = APP_WIDTH - PADDLE_WIDTH;
    else paddle.x = x;
}

function lockChangeAlert() {
  if (document.pointerLockElement === canvas ||
      document.mozPointerLockElement === canvas) {
    document.addEventListener("mousemove", updatePosition, false);
  } else {
    document.removeEventListener("mousemove", updatePosition, false);
  }
}

function updatePosition(e) {
    var x = paddle.getX() + e.movementX;
    if (x >= APP_WIDTH - PADDLE_WIDTH) {
        paddle.setPosition(APP_WIDTH - PADDLE_WIDTH, paddle.getY());
    }
    else if (x < 0) {
        paddle.setPosition(0, paddle.getY());
    }
    else {
        paddle.setPosition(x, paddle.getY());
    }
}

function start(){
	if(level != 1){
        levelup();
    }
    else{
        playMusic();
        setup();
    }
}

    if (typeof start === 'function') {
        start();
    }

};
